@extends('layouts.back-end.app-seller')

@section('title')
{{ Session::get('basicInfo')['companyName'] }} {{'| Rank List' }}
@endsection

@push('css_or_js')
    <link href="{{asset('public/assets/back-end')}}/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">

    <link href="{{asset('public/assets/back-end')}}/css/seller_custom.css?v={{ time() }}" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">
       <link href="{{asset('public/assets/back-end')}}/css/select2.min.css" rel="stylesheet"/>
    <link href="{{asset('public/assets/back-end/css/croppie.css')}}" rel="stylesheet">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Custom styles for this page -->
    <link href="{{asset('public/assets/back-end')}}/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    <style>
      table tr td a {
            color: white !important;
        }
       a:hover{
           color: white !important;
        }
        .text_green{
          color: green;
        }
        .text_red{
          color: red;
        }
    </style>
@endpush
@section('content')
@include('layouts.back-end.partials-sellers._top_header')
 <div class="content container-fluid">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{url('seller/dashboard')}}">Dashboard</a></li>
            <li class="breadcrumb-item" aria-current="page">Total Sales</li>
            <li class="breadcrumb-item" aria-current="page"><a style="max-height:30px; padding: 0px;" class=" btn-info btn-sm  " href="javascript:history.go(-1)"> <i class="tio-arrow-upward nav-icon"></i>Upline</a></li>
        </ol>
    </nav>

      <div class="row" style="margin-top: 20px" id="banner-table">
        <div class="card col-md-12 m-3">

             <form action="{{ url('seller/tree_search') }}" method="post">
              <div class="row ">
                @csrf
                <div class="col">
                  <input type="text" class="form-control" name="user_id" placeholder="Search User"  required="required">
                </div>
                <div class="col" align="left" >
                   <button type="Submit" class="btn btn-primary btn-sm"  style="width: 100px; font-size: 12px;" required="required"><i class="fa fa-level-down" style="font-size: 18px;" aria-hidden="true"></i>Submit</button>
                </div>
              </div>
             </form>

          <div class="row gx-2 gx-lg-3">
            <div class="col-sm-6 col-lg-3 mb-3 mb-lg-5 shadow card-hover-shadow">
                <!-- Card -->
              @if(!empty($member_tree_details))
                <a class="card card-hover-shadow h-100" href="#">
                    <div class="card-body">
                        <h6 class="card-subtitle" align="center"><span class="text_green">{{ $member_tree_details->user_id }}</span><span class="text_red"> Top User </span></h6>
                        <div class="row align-items-center gx-2 mb-1">
                           <table class=" table-bordered">

                             <tr>
                               <td>Ref. By</td>
                               <td colspan="3"  align="center">{{ $member_tree_details->sponser }}</td>
                             </tr>
                             <tr>
                               <td>Rank</td>
                               <td colspan="3">{{ $member_tree_details->rank }}</td>
                             </tr>
                             <tr>
                               <td>Details</td>
                               <td>Sales 1</td>
                               <td>Sales 2</td>
                               <td>Sales 3</td>
                             </tr>
                             <tr>
                               <td>Total User</td>
                               <td>{{ $member_tree_details->left_count }}</td>
                               <td>{{ $member_tree_details->middle_count }}</td>
                               <td>{{ $member_tree_details->right_count }}</td>
                             </tr>
                             <tr>
                               <td>Total Sale</td>
                               <td>{{ $member_tree_details->left_pv }}</td>
                               <td>{{ $member_tree_details->middle_pv }}</td>
                               <td>{{ $member_tree_details->right_pv }}</td>
                             </tr>
                             <tr>
                               <td>Present Balance</td>
                               <td>{{ $member_tree_details->left_pv_flashable }}</td>
                               <td>{{ $member_tree_details->middle_pv_flashable }}</td>
                               <td>{{ $member_tree_details->right_pv_flashable }}</td>
                             </tr>
                           </table>
                        </div>
                    </div>
                  </a>
                @else
                  <a class="card card-hover-shadow h-100" href="#">
                    <div class="card-body">
                        <div class="row align-items-center gx-2 mb-15 pt-50" >
                          Empty
                        </div>
                    </div>
                  </a>
                @endif
            </div>

            <div class="col-sm-6 col-lg-3 mb-3 mb-lg-5 shadow card-hover-shadow">
              @if(!empty($member_tree_details))
              @php
               $top_left = DB::table('sellers')->where('placement_id', $member_tree_details->id)->where('placement', 'L')->first();
              @endphp
              @endif
              @if(!empty($top_left))
                 <a class="card card-hover-shadow h-100" href="{{url('seller/placement-tree/'.$top_left->user_id) }}">
                    <div class="card-body">
                        <h6 class="card-subtitle" align="center"><span class="text_green">{{ $top_left->user_id }}</span><span class="text_red"> Sales 1</span></h6>
                        <div class="row align-items-center gx-2 mb-1">
                          <table class=" table-bordered">

                             <tr>
                               <td>Ref. By</td>
                               <td colspan="3"  align="center">{{ $top_left->sponser }}</td>
                             </tr>
                             <tr>
                               <td>Rank</td>
                               <td colspan="3">{{ $top_left->rank }}</td>
                             </tr>
                              <tr>
                               <td>Details</td>
                               <td>Sales 1</td>
                               <td>Sales 2</td>
                               <td>Sales 3</td>
                             </tr>
                             <tr>
                               <td>Total User</td>
                               <td>{{ $top_left->left_count }}</td>
                               <td>{{ $top_left->middle_count }}</td>
                               <td>{{ $top_left->right_count }}</td>
                             </tr>
                             <tr>
                               <td>Total Sale</td>
                               <td>{{ $top_left->left_pv }}</td>
                               <td>{{ $top_left->middle_pv }}</td>
                               <td>{{ $top_left->right_pv }}</td>
                             </tr>
                             <tr>
                               <td>Present Balance</td>
                               <td>{{ $top_left->left_pv_flashable }}</td>
                               <td>{{ $top_left->middle_pv_flashable }}</td>
                               <td>{{ $top_left->right_pv_flashable }}</td>
                             </tr>
                           </table>
                        </div>
                    </div>
                  </a>
                @else
                  <a class="card card-hover-shadow h-100" href="#">
                    <div class="card-body">

                        <div class="row align-items-center gx-2 mb-15 pt-50" >
                          Empty
                        </div>
                    </div>
                  </a>
                @endif
            </div>

            <div class="col-sm-6 col-lg-3 mb-3 mb-lg-5 shadow card-hover-shadow">
              @if(!empty($member_tree_details))
              @php
               $top_middle = DB::table('sellers')->where('placement_id', $member_tree_details->id)->where('placement', 'M')->first();
              @endphp
               @endif
              @if(!empty($top_middle))
                 <a class="card card-hover-shadow h-100" href="{{url('seller/placement-tree/'.$top_middle->user_id) }}">
                    <div class="card-body">
                        <h6 class="card-subtitle" align="center"><span class="text_green">{{ $top_middle->user_id }}</span><span class="text_red"> Sales 2</span></h6>
                        <div class="row align-items-center gx-2 mb-1">
                          <table class=" table-bordered">

                             <tr>
                               <td>Ref. By</td>
                               <td colspan="3" align="center">{{ $top_middle->sponser }}</td>
                             </tr>
                             <tr>
                               <td>Rank</td>
                               <td colspan="3">{{ $top_middle->rank }}</td>
                             </tr>
                             <tr>
                               <td>Details</td>
                               <td>Sales 1</td>
                               <td>Sales 2</td>
                               <td>Sales 3</td>
                             </tr>
                             <tr>
                               <td>Total User</td>
                               <td>{{ $top_middle->left_count }}</td>
                               <td>{{ $top_middle->middle_count }}</td>
                               <td>{{ $top_middle->right_count }}</td>
                             </tr>
                             <tr>
                               <td>Total Sale</td>
                               <td>{{ $top_middle->left_pv }}</td>
                               <td>{{ $top_middle->middle_pv }}</td>
                               <td>{{ $top_middle->right_pv }}</td>
                             </tr>
                             <tr>
                               <td>Present Balance</td>
                               <td>{{ $top_middle->left_pv_flashable }}</td>
                               <td>{{ $top_middle->middle_pv_flashable }}</td>
                               <td>{{ $top_middle->right_pv_flashable }}</td>
                             </tr>
                           </table>
                        </div>
                    </div>
                  </a>
                @else
                  <a class="card card-hover-shadow h-100" href="#">
                    <div class="card-body">

                        <div class="row align-items-center gx-2 mb-15 pt-50" >
                          Empty
                        </div>
                    </div>
                  </a>
                @endif
            </div>


            <div class="col-sm-6 col-lg-3 mb-3 mb-lg-5 shadow card-hover-shadow">
             @if(!empty($member_tree_details))
              @php
               $top_right = DB::table('sellers')->where('placement_id', $member_tree_details->id)->where('placement', 'R')->first();
              @endphp
            @endif
              @if(!empty($top_right))
                 <a class="card card-hover-shadow h-100" href="{{url('seller/placement-tree/'.$top_right->user_id) }}">
                    <div class="card-body">
                        <h6 class="card-subtitle" align="center"><span class="text_green">{{ $top_right->user_id }}</span> <span class="text_red"> Sales 3</span></h6>
                        <div class="row align-items-center gx-2 mb-1">
                          <table class=" table-bordered">

                             <tr>
                               <td>Ref. By</td>
                               <td colspan="3">{{ $top_right->sponser }}</td>
                             </tr>
                             <tr>
                               <td>Rank</td>
                               <td colspan="3">{{ $top_right->rank }}</td>
                             </tr>
                              <tr>
                               <td>Details</td>
                               <td>Sales 1</td>
                               <td>Sales 2</td>
                               <td>Sales 3</td>
                             </tr>
                             <tr>
                               <td>Total User</td>
                               <td>{{ $top_right->left_count }}</td>
                               <td>{{ $top_right->middle_count }}</td>
                               <td>{{ $top_right->right_count }}</td>
                             </tr>
                             <tr>
                               <td>Total Sale</td>
                               <td>{{ $top_right->left_pv }}</td>
                               <td>{{ $top_right->middle_pv }}</td>
                               <td>{{ $top_right->right_pv }}</td>
                             </tr>
                             <tr>
                              <td>Present Balance</td>
                               <td>{{ $top_right->left_pv_flashable }}</td>
                               <td>{{ $top_right->middle_pv_flashable }}</td>
                               <td>{{ $top_right->right_pv_flashable }}</td>
                             </tr>
                           </table>
                        </div>
                    </div>
                  </a>
                @else
                 <a class="card card-hover-shadow h-100" href="#">
                    <div class="card-body">

                        <div class="row align-items-center gx-2 mb-15 pt-50" >
                          Empty
                        </div>
                    </div>
                  </a>
                @endif
            </div>


          </div>
        </div>
      </div>
    </div>
    <br>
    @include('layouts.back-end.partials-sellers._bottom-navbar-fixed')

@endsection

@push('script')
    <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>
@endpush

@push('script_2')

 <script src="{{asset('public/assets/back-end')}}/js/select2.min.js"></script>
    <script>


    </script>

    @include('shared-partials.image-process._script',[
     'id'=>'main-banner-image-modal',
     'height'=>390,
     'width'=>960,
     'multi_image'=>false,
     'route'=>route('image-upload')
     ])

    <!-- Page level plugins -->
    <script src="{{asset('public/assets/back-end')}}/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="{{asset('public/assets/back-end')}}/vendor/datatables/dataTables.bootstrap4.min.js"></script>
    <script>
        $(document).ready(function () {
            $('#dataTable').DataTable();
        });
    </script>

    <script type="text/javascript">
        $(document).ready(function() {
           if((screen.width<=800))  {
              $('.remove_this').removeClass('main').addClass('done');
           }
        });
    </script>

    <script>
        function call_duty(){
            toastr.warning('Update your bank info first!','Warning!', {
                CloseButton: true,
                ProgressBar: true
            });
        }
    </script>
@endpush
